<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>PDF List | NCU LTD</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc." />
    <meta name="author" content="Zoyothemes" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="images/logo.png">

    <link href="assets/libs/simple-datatables/style.css" rel="stylesheet" type="text/css" />

    <!-- App css -->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

    <!-- Icons -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- Head CSS -->
    <script src="assets/js/head.js"></script>
    <!-- SweetAlert2 CSS & JS -->


</head>

<!-- body start -->

<body data-menu-color="dark" data-sidebar="default">
    <!-- Begin page -->
    <div id="app-layout">

        <!-- Topbar Start -->
        <div class="topbar-custom">
            <div class="container-fluid">
                <div class="d-flex justify-content-between">
                    <ul class="list-unstyled topnav-menu mb-0 d-flex align-items-center">
                        <li>
                            <button type="button" class="button-toggle-menu nav-link">
                                <iconify-icon icon="solar:hamburger-menu-linear" class="fs-22 align-middle text-dark">
                                </iconify-icon>
                            </button>
                        </li>
                        <li class="d-none d-lg-block">
                            <form class="app-search d-none d-md-block me-auto">
                                <div class="position-relative topbar-search">
                                    <iconify-icon icon="solar:minimalistic-magnifer-line-duotone"
                                        class="fs-18 align-middle text-dark position-absolute text-dark top-50 translate-middle-y ms-2">
                                    </iconify-icon>
                                    <input type="text" class="form-control shadow-none"
                                        placeholder="Search for somethings" />
                                </div>
                            </form>
                        </li>
                    </ul>

                    <ul class="list-unstyled topnav-menu mb-0 d-flex align-items-center gap-2">
                        <li class="dropdown topbar-dropdown">
                            <a class="nav-link dropdown-toggle me-0" data-bs-toggle="dropdown" href="#" role="button"
                                aria-haspopup="false" aria-expanded="false">
                                <iconify-icon icon="solar:earth-bold-duotone" class="fs-22 align-middle"
                                    id="selected-language-image"></iconify-icon>
                            </a>

                            <div class="dropdown-menu dropdown-menu-end profile-dropdown">
                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="en">
                                    <img src="assets/images/flags/lang-flag/circle-us.svg" class="me-2"
                                        id="selected-language-image"><span class="align-middle">English</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="hi">
                                    <img src="assets/images/flags/lang-flag/circle-us.svg" class="me-2"
                                        id="selected-language-image"><span class="align-middle">Hindi</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-de.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">German</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-ca.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Canada</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-au.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Australia</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-ru.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Russian</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-si.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Italian</span>
                                </a>
                            </div>
                        </li>

                        <!-- Button Trigger Customizer Offcanvas -->
                        <li class="d-none d-sm-flex">
                            <button type="button" class="btn nav-link" data-toggle="fullscreen">
                                <iconify-icon icon="solar:full-screen-bold-duotone"
                                    class="fs-22 align-middle text-dark fullscreen noti-icon"></iconify-icon>
                            </button>
                        </li>

                        <!-- Light/Dark Mode Button Themes -->
                        <li class="d-none d-sm-flex">
                            <button type="button" class="btn nav-link d-flex align-items-center justify-content-center"
                                id="light-dark-mode">
                                <div class="d-flex align-items-center justify-content-center">
                                    <iconify-icon icon="solar:sun-2-bold-duotone"
                                        class="fs-22 text-dark align-middle dark-mode"></iconify-icon>
                                    <iconify-icon icon="solar:moon-bold-duotone"
                                        class="fs-22 text-dark align-middle light-mode"></iconify-icon>
                                </div>
                            </button>
                        </li>

                        <!-- Notifications -->
                        <li class="dropdown notification-list topbar-dropdown">
                            <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button"
                                aria-expanded="false" data-bs-auto-close="outside">
                                <iconify-icon icon="solar:bell-bing-bold-duotone" class="fs-22 text-dark align-middle">
                                </iconify-icon>
                            </a>


                        </li>

                        <!-- User Dropdown -->
                        <li class="dropdown notification-list topbar-dropdown">
                            <a class="nav-link dropdown-toggle nav-user me-0" data-bs-toggle="dropdown" href="#"
                                role="button" aria-haspopup="false" aria-expanded="false">
                                <img src="assets/images/users/avatar/avatar-07.svg" alt="user-image"
                                    class="img-fluid " />
                            </a>
                            <div class="dropdown-menu dropdown-menu-end profile-dropdown">
                                <!-- item-->
                                <div
                                    class="dropdown-header noti-title border-bottom border-dashed d-flex align-items-center">
                                    <img src="assets/images/users/avatar/avatar-07.svg" alt="user-image"
                                        class="avatar avatar-xs rounded-circle me-2" />
                                    <h6 class="text-overflow m-0">Nyanza Admin !</h6>
                                </div>
                                <!-- item-->
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf

                                    <button type="submit" class="dropdown-item notify-item">
                                        <iconify-icon icon="solar:logout-2-bold-duotone" class="fs-18 align-middle">
                                        </iconify-icon>
                                        <span>Logout</span>
                                    </button>
                                </form>

                            </div>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
        <!-- end Topbar -->

        <!-- Left Sidebar Start -->
        <div class="app-sidebar-menu">
            <div class="h-100" data-simplebar>

                <!--- Sidemenu -->
                <div id="sidebar-menu">

                    <div class="logo-box">
                        <a href="index.html" class="logo logo-light">
                            <span class="logo-sm">
                                <img src="images/logo.png" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="images/logo.png" alt="" height="26">
                            </span>
                        </a>
                        <a href="index.html" class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="images/logo.png" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="images/logo.png" alt="" height="26">
                            </span>
                        </a>
                    </div>

                    <ul id="side-navbar">

                        <li class="menu-title">Menu</li>

                        <li>
                            <a href="#sidebarDashboards" data-bs-toggle="collapse">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:widget-6-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Dashboards </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <div class="collapse" id="sidebarDashboards">
                                <ul class="nav-second-level">
                                    <li>
                                        <a href="{{ route('admin') }}" class="tp-link"><i
                                                class="ti ti-point"></i>Home</a>
                                    </li>
                                    <!-- <li>
                                            <a href="ecommerce.html" class="tp-link"><i class="ti ti-point"></i>E Commerce</a>
                                        </li> -->
                                </ul>
                            </div>
                        </li>

                        <li class="menu-title mt-2">Apps</li>

                        <li>
                            <a href="{{ route('pdfs.index') }}" class="tp-link">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:notes-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Pdf List </span>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('sliders.index') }}" class="tp-link">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:server-minimalistic-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Slider List </span>
                            </a>
                        </li>
                    </ul>
                </div>
                <!-- End Sidebar -->

                <div class="clearfix"></div>

            </div>
        </div>
        <!-- Left Sidebar End -->

        <!-- ============================================================== -->
        <!-- Start Page Content here -->
        <!-- ============================================================== -->

       <div class="content-page">
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">

            <div class="py-3 d-flex align-items-sm-center flex-sm-row flex-column">
                <div class="flex-grow-1">
                    <h4 class="fs-18 fw-medium m-0">PDF List</h4>
                </div>

                <div class="text-end">
                    <ol class="breadcrumb m-0 py-0">
                        <li class="breadcrumb-item active">
                            <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#pdfUploadModal">Add PDF</button>
                        </li>
                    </ol>

                    <!-- PDF Upload Modal -->
                    <div class="modal fade" id="pdfUploadModal" tabindex="-1" aria-labelledby="pdfUploadModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="pdfUploadModalLabel">PDF Upload</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form action="{{ route('pdfs.store') }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label for="pdfTitle" class="form-label">PDF Title</label>
                                            <input type="text" class="form-control form-control-lg" id="pdfTitle" name="title" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="pdfFile" class="form-label">PDF File</label>
                                            <input class="form-control" type="file" id="pdfFile" name="pdf_file" accept="application/pdf" required>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Upload PDF</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table datatable" id="datatable_1">
                                    <thead>
                                        <tr>
                                            <th style="width: 16px;">
                                                <div class="form-check mb-0 ms-n1">
                                                    <input type="checkbox" class="form-check-input" name="select-all" id="select-all">
                                                </div>
                                            </th>
                                            <th>Title</th>
                                            <th>Uploaded At</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($pdfs  as $index => $pdf)
                                        <tr>
                                            <!-- <td style="width: 16px;">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input row-checkbox" id="pdfCheck{{ $pdf->id }}">
                                                </div>
                                            </td> -->
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $pdf->title }}</td>
                                            <td>{{ $pdf->created_at->format('d M Y, H:i') }}</td>
                                            <td class="text-end">
                                                <!-- Preview Modal Button -->
                                                <button type="button" class="btn btn-icon btn-sm border shadow-sm me-1" data-bs-toggle="modal" data-bs-target="#previewModal{{ $pdf->id }}" title="Preview">
                                                    <i class="mdi mdi-eye fs-14 text-info"></i>
                                                </button>

                                                <!--Download Button -->
                                                @if(!empty($pdf->file_path))
                                                <a href="{{ asset($pdf->file_path) }}" target="_blank" class="btn btn-sm btn-outline-success border shadow-sm me-1" title="Download Attachment" download>
                                                    <i class="mdi mdi-download fs-14 me-1"></i> Download Attachment
                                                </a>
                                                @endif

                                                <!-- Edit Modal Button -->
                                                <button type="button" class="btn btn-icon btn-sm border shadow-sm me-1" data-bs-toggle="modal" data-bs-target="#editModal{{ $pdf->id }}" title="Edit">
                                                    <i class="mdi mdi-pencil-outline fs-14 text-primary"></i>
                                                </button>

                                                <!-- Delete Modal Button -->
                                                <button type="button" class="btn btn-icon btn-sm border shadow-sm" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $pdf->id }}" title="Delete">
                                                    <i class="mdi mdi-delete fs-14 text-danger"></i>
                                                </button>
                                            </td>
                                        </tr>

                                        <!-- Preview Modal -->
                                        <div class="modal fade" id="previewModal{{ $pdf->id }}" tabindex="-1" aria-labelledby="previewModalLabel{{ $pdf->id }}" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="previewModalLabel{{ $pdf->id }}">{{ $pdf->title }} - Preview</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        @if(!empty($pdf->file_path))
                                                        <iframe src="{{ asset($pdf->file_path) }}" style="width: 100%; height: 500px;" frameborder="0"></iframe>
                                                        @else
                                                        <p class="text-muted">No PDF file uploaded.</p>
                                                        @endif
                                                    </div>
                                                    <div class="modal-footer">
                                                        @if(!empty($pdf->file_path))
                                                        <a href="{{ asset($pdf->file_path) }}" target="_blank" class="btn btn-primary">Open in new tab</a>
                                                        @endif
                                                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Edit Modal -->
                                        <div class="modal fade" id="editModal{{ $pdf->id }}" tabindex="-1" aria-labelledby="editModalLabel{{ $pdf->id }}" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('pdfs.update', $pdf->id) }}" method="POST" enctype="multipart/form-data">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="editModalLabel{{ $pdf->id }}">Edit PDF</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="mb-3">
                                                                <label for="editTitle{{ $pdf->id }}" class="form-label">PDF Title</label>
                                                                <input type="text" class="form-control" id="editTitle{{ $pdf->id }}" name="title" value="{{ $pdf->title }}" required>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="editPdfFile{{ $pdf->id }}" class="form-label">Change PDF (optional)</label>
                                                                <input type="file" class="form-control" id="editPdfFile{{ $pdf->id }}" name="pdf_file" accept="application/pdf">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                                            <button type="submit" class="btn btn-primary">Update PDF</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Delete Modal -->
                                        <div class="modal fade" id="deleteModal{{ $pdf->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $pdf->id }}" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <form action="{{ route('pdfs.destroy', $pdf->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $pdf->id }}">Delete PDF</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            Are you sure you want to delete <strong>{{ $pdf->title }}</strong>?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                                            <button type="submit" class="btn btn-danger">Delete</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        @endforeach
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Footer Start -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col fs-13 text-muted text-center">
                    &copy; <script>document.write(new Date().getFullYear())</script> - Made by <a href="#!" class="text-reset fw-semibold">Zoyothemes</a>
                </div>
            </div>
        </div>
    </footer>
    <!-- end Footer -->

</div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <!-- Vendor -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/iconify-icon/iconify-icon.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
    <script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>
    <script src="assets/libs/feather-icons/feather.min.js"></script>

    <!-- Simple Datatables JS -->
    <script src="assets/libs/simple-datatables/umd/simple-datatables.js"></script>

    <!-- Simple Datatables Init JS -->
    <script src="assets/js/pages/simple-datatables.init.js"></script>

    <!-- App js-->
    <script src="assets/js/app.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    @if(session('success'))
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: '{{ session('
        success ') }}',
        timer: 3000,
        showConfirmButton: false
    });
    @endif

    @if(session('error'))
    Swal.fire({
        icon: 'error',
        title: 'Oops!',
        text: '{{ session('
        error ') }}',
        timer: 4000,
        showConfirmButton: true
    });
    @endif
    </script>


</body>

</html>