<?php

namespace App\Http\Controllers;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Illuminate\Support\Facades\Storage;

class SliderController extends Controller
{
    public function index()
    {
        $sliders = Slider::orderBy('order')->get();
        return view('admin.sliders', compact('sliders'));
    }

public function store(Request $request)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'subtitle' => 'nullable|string|max:255',
        'description' => 'nullable|string',
        'image' => 'required|image|mimes:jpg,png,jpeg,gif',
        'pdf' => 'nullable|mimes:pdf|max:10240', // optional PDF
    ]);

    // Ensure folders exist
    $imagePath = public_path('uploads/sliders');
    $pdfPath = $imagePath . '/pdfs';

    if (!file_exists($imagePath)) {
        mkdir($imagePath, 0777, true);
    }
    if (!file_exists($pdfPath)) {
        mkdir($pdfPath, 0777, true);
    }

    // Upload image
    $image = $request->file('image');
    $imageName = time() . '_' . $image->getClientOriginalName();
    $image->move($imagePath, $imageName);

    // Upload PDF if exists
    $pdfFilePath = null;
    if ($request->hasFile('pdf')) {
        $pdf = $request->file('pdf');
        $pdfName = time() . '_' . $pdf->getClientOriginalName();
        $pdf->move($pdfPath, $pdfName);
        $pdfFilePath = 'uploads/sliders/pdfs/' . $pdfName;
    }

    // Save slider
    Slider::create([
        'title' => $request->title,
        'subtitle' => $request->subtitle,
        'description' => $request->description,
        'image' => 'uploads/sliders/' . $imageName,
        'pdf' => $pdfFilePath,
        'order' => $request->order ?? 0,
    ]);

    return redirect()->back()->with('success', 'Slider added successfully.');
}

public function update(Request $request, Slider $slider)
{
    $request->validate([
        'title' => 'required|string|max:255',
        'subtitle' => 'nullable|string|max:255',
        'description' => 'nullable|string',
        'image' => 'nullable|image|mimes:jpg,png,jpeg,gif',
        'pdf' => 'nullable|mimes:pdf|max:10240', // optional PDF
    ]);

    // Ensure folders exist
    $imagePath = public_path('uploads/sliders');
    $pdfPath = $imagePath . '/pdfs';

    if (!file_exists($imagePath)) {
        mkdir($imagePath, 0777, true);
    }
    if (!file_exists($pdfPath)) {
        mkdir($pdfPath, 0777, true);
    }

    // Upload new image if provided
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $imageName = time() . '_' . $image->getClientOriginalName();
        $image->move($imagePath, $imageName);
        $slider->image = 'uploads/sliders/' . $imageName;
    }

    // Upload new PDF if provided
    if ($request->hasFile('pdf')) {
        $pdf = $request->file('pdf');
        $pdfName = time() . '_' . $pdf->getClientOriginalName();
        $pdf->move($pdfPath, $pdfName);
        $slider->pdf = 'uploads/sliders/pdfs/' . $pdfName;
    }

    // Update other fields
    $slider->update([
        'title' => $request->title,
        'subtitle' => $request->subtitle,
        'description' => $request->description,
        'order' => $request->order ?? $slider->order,
    ]);

    return redirect()->back()->with('success', 'Slider updated successfully.');
}



    public function destroy(Slider $slider)
    {
        $slider->delete();
        return redirect()->back()->with('success', 'Slider deleted successfully.');
    }

    public function show($id)
    {
        try {
            // Decrypt ID
            $sliderId = decrypt($id);
        } catch (DecryptException $e) {
            abort(404); // Invalid or modified ID
        }
        
         $sliderId = decrypt($id);
        // Fetch slider
        $slider = Slider::findOrFail($sliderId);

        return view('news', compact('slider'));
    }
}

