<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Log In </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc." />
    <meta name="author" content="Zoyothemes" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="images/logo.png">

    <link href="assets/libs/swiper/swiper-bundle.min.css" rel="stylesheet">

    <!-- App css -->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

    <!-- Icons -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- Head CSS -->
    <script src="assets/js/head.js"></script>
</head>

<body>
    <!-- Begin page -->
    <div class="account-page">
        <div class="container-fluid p-0">
            <div class="row g-0 px-3 py-3 vh-100">

                <div
                    class="col-xl-6 col-lg-6 col-md-6 d-md-block d-none body-color justify-content-center align-content-center rounded-4">
                    <div class="">
                        <div class="swiper testi-swiper auth-user-review">
                            <div class="swiper-wrapper">

                                @foreach($sliders as $slider)
                                <div class="swiper-slide">
                                    <div class="carousel-images mb-5 text-center">
                                        <img src="{{ asset($slider->image) }}" alt="{{ $slider->title }}"
                                            class="img-fluid" style="max-height: 280px; object-fit: contain;">
                                    </div>

                                    <p class="prelead mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                            viewBox="0 0 24 24">
                                            <path fill="#ffffff"
                                                d="M4.583 17.321C3.553 16.227 3 15 3 13.011c0-3.5 2.457-6.637 6.03-8.188l.893 1.378c-3.335 1.804-3.987 4.145-4.247 5.621c.537-.278 1.24-.375 1.929-.311c1.804.167 3.226 1.648 3.226 3.489a3.5 3.5 0 0 1-3.5 3.5a3.87 3.87 0 0 1-2.748-1.179" />
                                        </svg>

                                        {{ $slider->description }}

                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                            viewBox="0 0 24 24">
                                            <path fill="#ffffff"
                                                d="M19.417 6.679C20.447 7.773 21 9 21 10.989c0 3.5-2.456 6.637-6.03 8.188l-.893-1.378c3.335-1.804 3.987-4.145 4.248-5.621c-.537.278-1.24.375-1.93.311c-1.804-.167-3.226-1.648-3.226-3.489a3.5 3.5 0 0 1 3.5-3.5c1.073 0 2.1.49 2.748 1.179" />
                                        </svg>
                                    </p>

                                    <h4 class="mb-1 fs-16">{{ $slider->title }}</h4>

                                    @if($slider->subtitle)
                                    <p class="mb-0">{{ $slider->subtitle }}</p>
                                    @endif
                                </div>
                                @endforeach

                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-xl-5 col-md-5 col-xxl-5 justify-content-center align-content-center mx-auto">
                    <div class="row">
                        <div class="col-xl-8 mx-auto">

                            <div class="mb-3 p-0 text-start">
                                <div class="auth-brand">
                                    <a href="index.html" class="logo logo-light">
                                        <span class="logo-sm">
                                            <img src="images/logo.png" alt="" height="40">
                                        </span>
                                    </a>
                                    <a href="index.html" class="logo logo-dark">
                                        <span class="logo-sm">
                                            <img src="images/logo.png" alt="" height="40">
                                        </span>
                                    </a>
                                </div>
                            </div>

                            <div class="auth-title-section mb-3 text-start">
                                <h4 class="text-dark fw-medium mb-2">Welcome Back</h4>
                                <p class="text-muted fs-14 mb-0">Welcome back, please enter your detail</p>
                            </div>

                            <div class="card mb-0 shadow-none border">
                                <div class="card-body p-lg-4">
                                    <div class="mb-0">
                                        <div>
                                            <form method="POST" action="{{ route('login.submit') }}">
                                                @csrf

                                                <div class="form-group mb-3">
                                                    <label for="emailaddress" class="form-label">Username</label>
                                                    <input class="form-control" type="email" name="email" required
                                                        placeholder="Enter Email">

                                                </div>

                                                <div class="form-group mb-3">
                                                    <label for="password" class="form-label">Password</label>
                                                    <input class="form-control" type="password" name="password" required
                                                        placeholder="Enter Password">
                                                </div>

                                                <div class="form-group d-flex mb-3">
                                                    <div class="col-sm-6">
                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input"
                                                                id="checkbox-signin" checked>
                                                            <label class="form-check-label"
                                                                for="checkbox-signin">Remember me</label>
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col-sm-6 text-end">
                                                            <a class='text-muted fs-14' href='auth-recoverpw.html'>Forgot password?</a>                             
                                                        </div> -->
                                                </div>

                                                <div class="form-group mb-0">
                                                    <div class="d-grid">
                                                        <button class="btn btn-primary fw-semibold" type="submit"> Sign
                                                            In </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>

                                        <div class="saprator my-3"><span>@if ($errors->any())
                                                <div class="alert alert-danger">
                                                    {{ $errors->first() }}
                                                </div>
                                                @endif
                                            </span></div>


                                    </div>
                                </div>
                            </div>

                            <div class="mt-4 text-center mx-auto">
                                <ul class="flex flex-wrap list-inline">
                                    <li class="list-inline-item">
                                        <a class="text-muted fs-12 me-2" href="#">Terms & Condition</a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="text-muted fs-12 me-2" href="#">Privacy Policy</a>
                                    </li>
                                    <li class="list-inline-item">
                                        <a class="text-muted fs-12" href="#">Help</a>
                                    </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- END wrapper -->

    <!-- Vendor -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/iconify-icon/iconify-icon.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
    <script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>
    <script src="assets/libs/feather-icons/feather.min.js"></script>

    <script src="assets/libs/swiper/swiper-bundle.min.js"></script>
    <script src="assets/js/pages/swiper.init.js"></script>

    <!-- App js-->
    <script src="assets/js/app.js"></script>

</body>

</html>