<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TeamMember;

class TeamController extends Controller
{
    public function index(){
        $teamsMember = TeamMember::orderBy('priority')->get();

        return view('admin.teams', compact('teamsMember'));
    }

    public function getPriority($position){
        return match(strtolower($position)){
        'chairperson' => 1,
        'vice chair' => 2,
        'general menager' => 3,
        default => 10,
        
        };
    }

    public function store(Request $request){
        $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|string:max:255',
            'qualification' => 'nullable|string',
            'description' => 'nullable|string',
            'photo' => 'required|image|mimes:jpg,png,jpeg,gif',
            'category' => 'required|string',
        ]);

        //ensure folders exists

        $photoPath = public_path('uploads/team');

        if(!file_exists($photoPath)){
            mkdir($photoPath,0777,true);
        }

        $photo = $request->file('photo');
        $photoName = time().'_'.$photo->getClientOriginalName();
        $photo->move($photoPath, $photoName);

        TeamMember::create([
            'name' => $request->name,
            'position' => $request->position,
            'qualification' => $request->qualification,
            'description' => $request->description,
            'photo' => 'uploads/team/' . $photoName,
            'category' => $request->category,
            'priority' => $this->getPriority($request->position),
        ]);

        return redirect()->back()->with('success', 'Team member added');
    }

    public function update(Request $request, TeamMember $memberId,$memberId2)
    {
        $teamember = TeamMember::where("id",$memberId2)->first();
       
        
         $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|string:max:255',
            'qualification' => 'nullable|string',
            'description' => 'nullable|string',
            'photo' => 'required|image|mimes:jpg,png,jpeg,gif',
            'category' => 'required|string',
        ]);

        //ensure folders exists

        $photoPath = public_path('uploads/team');

        if(!file_exists($photoPath)){
            mkdir($photoPath,0777,true);
        }

        // update photo if provided
        if($request->hasfile('photo')){
            $photo = $request->file('photo');
            $photoName = time().'_'.$photo->getClientOriginalName();
            $photo->move($photoPath, $photoName);
            $memberId->photo = 'uploads/team/' . $photoName;
        }
        
        // dd($memberId);

        $teamember->update([
            'name' => $request->name,
            'position' => $request->position,
            'qualification' => $request->qualification,
            'description' => $request->description,
            'category' => $request->category,
            'priority' => $this->getPriority($request->position),
        ]);
        if($request->hasfile('photo')){
             $teamember->update([
              $teamember->photo = 'uploads/team/' . $photoName,
                ]);   
        }

        return redirect()->back()->with('success', 'Team member updated successfully!');
    }

    public function destroy(TeamMember $memberId,$memberId2)
    {
        $teamember = TeamMember::where("id",$memberId2)->first();
        // $memberId->delete();
        $teamember->delete();
        return redirect()->back()->with('success', 'Team member deleted successfully!');
    }

    public function show(){
        $boardMembers = TeamMember::where('category', 'board')
            ->orderBy('priority')
            ->get();

        $managementMembers = TeamMember::where('category', 'management')
            ->orderBy('priority')
            ->get();

        return view('our-team', compact(
            'boardMembers',
            'managementMembers'
        ));
    }
}