<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>NCU Dashboard </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc." />
    <meta name="author" content="Zoyothemes" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="images/logo.png">

    <!-- App css -->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

    <!-- Icons -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />

    <!-- Head CSS -->
    <script src="assets/js/head.js"></script>
</head>

<!-- body start -->

<body data-menu-color="dark" data-sidebar="default">

    <!-- Start Begin Page -->
    <div id="app-layout">

        <!-- Topbar Start -->
        <div class="topbar-custom">
            <div class="container-fluid">
                <div class="d-flex justify-content-between">
                    <ul class="list-unstyled topnav-menu mb-0 d-flex align-items-center">
                        <li>
                            <button type="button" class="button-toggle-menu nav-link">
                                <iconify-icon icon="solar:hamburger-menu-linear" class="fs-22 align-middle text-dark">
                                </iconify-icon>
                            </button>
                        </li>
                        <li class="d-none d-lg-block">
                            <form class="app-search d-none d-md-block me-auto">
                                <div class="position-relative topbar-search">
                                    <iconify-icon icon="solar:minimalistic-magnifer-line-duotone"
                                        class="fs-18 align-middle text-dark position-absolute text-dark top-50 translate-middle-y ms-2">
                                    </iconify-icon>
                                    <input type="text" class="form-control shadow-none"
                                        placeholder="Search for somethings" />
                                </div>
                            </form>
                        </li>
                    </ul>

                    <ul class="list-unstyled topnav-menu mb-0 d-flex align-items-center gap-2">
                        <li class="dropdown topbar-dropdown">
                            <a class="nav-link dropdown-toggle me-0" data-bs-toggle="dropdown" href="#" role="button"
                                aria-haspopup="false" aria-expanded="false">
                                <iconify-icon icon="solar:earth-bold-duotone" class="fs-22 align-middle"
                                    id="selected-language-image"></iconify-icon>
                            </a>

                            <div class="dropdown-menu dropdown-menu-end profile-dropdown">
                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="en">
                                    <img src="assets/images/flags/lang-flag/circle-us.svg" class="me-2"
                                        id="selected-language-image"><span class="align-middle">English</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="hi">
                                    <img src="assets/images/flags/lang-flag/circle-us.svg" class="me-2"
                                        id="selected-language-image"><span class="align-middle">Hindi</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-de.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">German</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-ca.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Canada</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-au.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Australia</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-ru.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Russian</span>
                                </a>

                                <!-- item-->
                                <a href="javascript:void(0);" class="dropdown-item">
                                    <img src="assets/images/flags/lang-flag/circle-si.svg" class="me-2"
                                        id="selected-language-image"> <span class="align-middle">Italian</span>
                                </a>
                            </div>
                        </li>

                        <!-- Button Trigger Customizer Offcanvas -->
                        <li class="d-none d-sm-flex">
                            <button type="button" class="btn nav-link" data-toggle="fullscreen">
                                <iconify-icon icon="solar:full-screen-bold-duotone"
                                    class="fs-22 align-middle text-dark fullscreen noti-icon"></iconify-icon>
                            </button>
                        </li>

                        <!-- Light/Dark Mode Button Themes -->
                        <li class="d-none d-sm-flex">
                            <button type="button" class="btn nav-link d-flex align-items-center justify-content-center"
                                id="light-dark-mode">
                                <div class="d-flex align-items-center justify-content-center">
                                    <iconify-icon icon="solar:sun-2-bold-duotone"
                                        class="fs-22 text-dark align-middle dark-mode"></iconify-icon>
                                    <iconify-icon icon="solar:moon-bold-duotone"
                                        class="fs-22 text-dark align-middle light-mode"></iconify-icon>
                                </div>
                            </button>
                        </li>

                        <!-- Notifications -->
                        <li class="dropdown notification-list topbar-dropdown">
                            <a class="nav-link dropdown-toggle" data-bs-toggle="dropdown" href="#" role="button"
                                aria-expanded="false" data-bs-auto-close="outside">
                                <iconify-icon icon="solar:bell-bing-bold-duotone" class="fs-22 text-dark align-middle">
                                </iconify-icon>
                            </a>


                        </li>

                        <!-- User Dropdown -->
                        <li class="dropdown notification-list topbar-dropdown">
                            <a class="nav-link dropdown-toggle nav-user me-0" data-bs-toggle="dropdown" href="#"
                                role="button" aria-haspopup="false" aria-expanded="false">
                                <img src="assets/images/users/avatar/avatar-07.svg" alt="user-image"
                                    class="img-fluid " />
                            </a>
                            <div class="dropdown-menu dropdown-menu-end profile-dropdown">
                                <!-- item-->
                                <div
                                    class="dropdown-header noti-title border-bottom border-dashed d-flex align-items-center">
                                    <img src="assets/images/users/avatar/avatar-07.svg" alt="user-image"
                                        class="avatar avatar-xs rounded-circle me-2" />
                                    <h6 class="text-overflow m-0">Nyanza Admin !</h6>
                                </div>

                                <!-- item-->
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf

                                    <button type="submit" class="dropdown-item notify-item">
                                        <iconify-icon icon="solar:logout-2-bold-duotone" class="fs-18 align-middle">
                                        </iconify-icon>
                                        <span>Logout</span>
                                    </button>
                                </form>

                            </div>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
        <!-- end Topbar -->

        <!-- Left Sidebar Start -->
        <div class="app-sidebar-menu">
            <div class="h-100" data-simplebar>

                <!--- Sidemenu -->
                <div id="sidebar-menu">

                    <div class="logo-box">
                        <a href="index.html" class="logo logo-light">
                            <span class="logo-sm">
                                <img src="images/logo.png" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="images/logo.png" alt="" height="26">
                            </span>
                        </a>
                        <a href="index.html" class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="images/logo.png" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="images/logo.png" alt="" height="26">
                            </span>
                        </a>
                    </div>

                    <ul id="side-navbar">

                        <li class="menu-title">Menu</li>

                        <li>
                            <a href="#sidebarDashboards" data-bs-toggle="collapse">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:widget-6-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Dashboards </span>
                                <span class="menu-arrow"></span>
                            </a>
                            <div class="collapse" id="sidebarDashboards">
                                <ul class="nav-second-level">
                                    <li>
                                        <a href="{{ route('admin') }}" class="tp-link"><i
                                                class="ti ti-point"></i>Home</a>
                                    </li>
                                    <!-- <li>
                                            <a href="ecommerce.html" class="tp-link"><i class="ti ti-point"></i>E Commerce</a>
                                        </li> -->
                                </ul>
                            </div>
                        </li>

                        <li class="menu-title mt-2">Apps</li>

                        <li>
                            <a href="{{ route('pdfs.index') }}" class="tp-link">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:notes-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Pdf List </span>
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('sliders.index') }}" class="tp-link">
                                <span class="nav-icon">
                                    <iconify-icon icon="solar:server-minimalistic-bold-duotone"></iconify-icon>
                                </span>
                                <span class="sidebar-text"> Slider List </span>
                            </a>
                        </li>


                    </ul>
                </div>
                <!-- End Sidebar -->

                <div class="clearfix"></div>

            </div>
        </div>
        <!-- Left Sidebar End -->

        <!-- -------------------------------------------------------------- -->
        <!-- Start Right Content Here -->
        <!-- -------------------------------------------------------------- -->
        <div class="content-page">
            <div class="content">

                <!-- Start Content-->
                <div class="container-fluid">
                    <div class="py-3 d-flex align-items-sm-center flex-sm-row flex-column">
                        <div class="flex-grow-1">
                            <h4 class="fs-18 fw-medium m-0">Dashboard</h4>
                        </div>
                    </div>

                    <!-- Start Main Widgets -->
                    <div class="row">

                        <!-- SLIDES COUNT -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-3">
                                        <div
                                            class="p-2 bg-primary-subtle rounded-2 border-top border-primary shadow-sm">
                                            <iconify-icon icon="solar:gallery-broken"
                                                class="align-middle fs-26 text-primary"></iconify-icon>
                                        </div>

                                        <div class="d-flex flex-column">
                                            <h5 class="title fs-14 fw-normal text-dark mb-1">Total Slides</h5>
                                            <div class="fs-18 fw-medium mb-0 me-2 text-dark mb-1">
                                                {{ $sliderCount }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="card-footer bg-muted-color border-top d-flex align-content-center justify-content-between py-2 overflow-hidden">
                                    <span class="text-success">
                                        <iconify-icon icon="solar:arrow-up-bold-duotone"
                                            class="align-middle fs-16 text-success"></iconify-icon>
                                    </span>
                                    <p class="mb-0 text-dark">All active slides</p>
                                </div>
                            </div>
                        </div>

                        <!-- PDF COUNT -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-3">
                                        <div
                                            class="p-2 bg-warning-subtle rounded-2 border-top border-warning shadow-sm">
                                            <iconify-icon icon="solar:file-text-broken"
                                                class="align-middle fs-26 text-warning"></iconify-icon>
                                        </div>

                                        <div class="d-flex flex-column">
                                            <div class="fs-14 fw-normal text-dark mb-1">Total PDFs</div>
                                            <div class="fs-18 fw-medium mb-0 me-2 text-dark mb-1">
                                                {{ $pdfCount }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="card-footer bg-muted-color border-top d-flex align-content-center justify-content-between py-2 overflow-hidden">
                                    <span class="text-success">
                                        <iconify-icon icon="solar:arrow-up-bold-duotone"></iconify-icon>
                                    </span>
                                    <p class="mb-0 text-dark">Uploaded documents</p>
                                </div>
                            </div>
                        </div>

                        <!-- OPTIONAL: KEEP OTHER CARDS STATIC OR REMOVE -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-3">
                                        <div
                                            class="p-2 bg-success-subtle rounded-2 border-top border-success shadow-sm">
                                            <iconify-icon icon="solar:verified-check-broken"
                                                class="align-middle fs-26 text-success"></iconify-icon>
                                        </div>

                                        <div class="d-flex flex-column">
                                            <div class="fs-14 fw-normal text-dark mb-1">System Status</div>
                                            <div class="fs-18 fw-medium mb-0 me-2 text-dark mb-1">OK</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer bg-muted-color border-top py-2">
                                    <p class="mb-0 text-dark">All services running</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-xxl-3">
                            <div class="card overflow-hidden">
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="p-2 bg-danger-subtle rounded-2 border-top border-danger shadow-sm">
                                            <iconify-icon icon="solar:clock-circle-broken"
                                                class="align-middle fs-26 text-danger"></iconify-icon>
                                        </div>

                                        <div class="d-flex flex-column">
                                            <div class="fs-14 fw-normal text-dark mb-1">Last Update</div>
                                            <div class="fs-18 fw-medium mb-0 me-2 text-dark mb-1">
                                                {{ now()->format('d M Y') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer bg-muted-color border-top py-2">
                                    <p class="mb-0 text-dark">Dashboard data</p>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- Start Main Widgets -->

                    <!-- Start Revenue and Recent Widgets -->

                    <!-- End Recent Transaction Orders -->

                </div> <!-- container-fluid -->
            </div> <!-- content -->

            <!-- Footer Start -->
            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col fs-13 text-muted text-center">
                            &copy; <script>
                            document.write(new Date().getFullYear())
                            </script> - Made by <a href="#!" class="text-reset fw-semibold">nyanza ICT</a>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- end Footer -->

        </div>
        <!-- -------------------------------------------------------------- -->
        <!-- End Right Content Here -->
        <!-- -------------------------------------------------------------- -->

    </div>
    <!-- End Begin Page -->

    <!-- Vendor -->
    <script src="assets/libs/jquery/jquery.min.js"></script>
    <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/libs/iconify-icon/iconify-icon.min.js"></script>
    <script src="assets/libs/simplebar/simplebar.min.js"></script>
    <script src="assets/libs/node-waves/waves.min.js"></script>
    <script src="assets/libs/waypoints/lib/jquery.waypoints.min.js"></script>
    <script src="assets/libs/jquery.counterup/jquery.counterup.min.js"></script>
    <script src="assets/libs/feather-icons/feather.min.js"></script>

    <!-- Echarts JS -->
    <script src="assets/libs/echarts/echarts.min.js"></script>

    <!-- Widgets Init Js -->
    <script src="assets/js/pages/crm-dashboard.init.js"></script>

    <!-- App js-->
    <script src="assets/js/app.js"></script>

</body>

</html>