<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PdfController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;

// Route::get('/', function () {
//     return view('welcome');
// });


// Route::get('/', function () {
//     return view('index');
// });
// Route::get('/', function () {
//     return view('index');
// })->name('home');



Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('/slider/{id}', [SliderController::class, 'show'])
    ->name('slider.show');
Route::get('/about-us', fn () => view('about-us'))->name('about');
Route::get('/news', fn () => view('news'))->name('news');

Route::get('/mission-vision', fn () => view('mission-vision'))->name('mission.vision');

Route::get('/our-team', fn () => view('our-team'))->name('team');

Route::get('/ncu-certificates', fn () => view('ncu-certificates'))->name('certificates');

Route::get('/ncu-partners', fn () => view('ncu-partners'))->name('partners');

Route::get('/our-assets', fn () => view('our-assets'))->name('assets');

/*
|--------------------------------------------------------------------------
| Target Groups (Farming)
|--------------------------------------------------------------------------
*/
Route::get('/cotton-farming', fn () => view('cotton-farming'))->name('cotton.farming');

Route::get('/mixed-farming', fn () => view('mixed-farming'))->name('mixed.farming');

Route::get('/fish-farming', fn () => view('fish-farming'))->name('fish.farming');

Route::get('/cattle-farming', fn () => view('cattle-farming'))->name('cattle.farming');

Route::get('/factory-processing', fn () => view('factory-processing'))->name('factory.processing');

/*
|--------------------------------------------------------------------------
| Services
|--------------------------------------------------------------------------
*/
Route::get('/providing-farming-inputs', fn () => view('providing-farming-inputs'))
    ->name('farming.inputs');

Route::get('/oversight-union-assets', fn () => view('oversight-union-assets'))
    ->name('oversight.assets');

Route::get('/improve-member-economy', fn () => view('improve-member-economy'))
    ->name('member.economy');

Route::get('/increase-major-crop-value', fn () => view('increase-major-crop-value'))
    ->name('crop.value');

/*
|--------------------------------------------------------------------------
| Contact
|--------------------------------------------------------------------------
*/
Route::get('/contact-us', fn () => view('contact-us'))->name('contact');
Route::get('/downloads', [PdfController::class, 'downloads'])->name('downloads');











// Login
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login.submit');
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected admin routes
Route::middleware('auth')->group(function () {
   Route::get('/admin', [AdminController::class, 'index'])->name('admin');
   Route::get('/pdfs', [PdfController::class, 'index'])->name('pdfs.index');
Route::get('/pdfs/create', [PdfController::class, 'create'])->name('pdfs.create');
Route::post('/pdfs', [PdfController::class, 'store'])->name('pdfs.store');
Route::get('/pdfs/{pdf}/download', [PdfController::class, 'download'])->name('pdfs.download');
Route::resource('pdfs', PdfController::class);

Route::resource('sliders', SliderController::class);
});